
/**
 * MAIN DOMAIN CONFIGURATION (for active-plan/script.js)
 * ====================================================
 * This is where you host your main website with:
 * - Homepage (index.html)
 * - Active plan page (active-plan/)
 * - Admin panel (admin-panel/)
 */

// PRODUCTION - Update these when deploying to live server
const MAIN_DOMAIN_PROD = "https://myaxisinsurance.online";
const DOWNLOADS_DOMAIN_PROD = "https://insuranceportalimobile.online";

const ENVIRONMENT = 'production';

/**
 * ACTIVE DOMAINS
 * ==============
 * These are automatically set based on ENVIRONMENT
 */
const MAIN_DOMAIN = ENVIRONMENT === 'production' ? MAIN_DOMAIN_PROD : MAIN_DOMAIN_LOCAL;
const DOWNLOADS_DOMAIN = ENVIRONMENT === 'production' ? DOWNLOADS_DOMAIN_PROD : DOWNLOADS_DOMAIN_LOCAL;

/**
 * USAGE INSTRUCTIONS
 * ==================
 * 
 * FOR LOCALHOST TESTING:
 * 1. Set ENVIRONMENT = 'local'
 * 2. Start main site: cd to main folder, run: php -S localhost:8000
 * 3. Start downloads site: cd to downloads-domain, run: php -S localhost:8080
 * 4. Test verification flow
 * 
 * FOR PRODUCTION DEPLOYMENT:
 * 1. Update MAIN_DOMAIN_PROD with your main domain URL
 * 2. Update DOWNLOADS_DOMAIN_PROD with your downloads domain URL
 * 3. Set ENVIRONMENT = 'production'
 * 4. Update active-plan/script.js line 261 and 413:
 *    const downloadsUrl = 'YOUR_DOWNLOADS_DOMAIN';
 * 5. Update downloads-domain/success.js line 4:
 *    const MAIN_DOMAIN = 'YOUR_MAIN_DOMAIN';
 * 
 * FILES TO UPDATE:
 * ----------------
 * 1. active-plan/script.js (line ~261 and ~413)
 *    - Replace: const downloadsUrl = 'http://localhost:8080';
 *    - With: const downloadsUrl = 'https://downloads.yoursite.com';
 * 
 * 2. downloads-domain/success.js (line ~4)
 *    - Replace: const MAIN_DOMAIN = 'http://localhost';
 *    - With: const MAIN_DOMAIN = 'https://yoursite.com';
 */

// Export for reference (not used in actual code, just documentation)
module.exports = {
    MAIN_DOMAIN,
    DOWNLOADS_DOMAIN,
    ENVIRONMENT
};
