<?php
/**
 * Delete All Submissions
 * Deletes all encrypted verification submissions from the data directory
 */

header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

require_once 'FileStorage.php';

try {
    $fileStorage = new FileStorage();
    
    // Delete all submissions
    $result = $fileStorage->deleteAllSubmissions();
    
    if ($result['success']) {
        error_log("All submissions deleted successfully");
        echo json_encode([
            'success' => true,
            'message' => 'All submissions deleted successfully'
        ]);
    } else {
        throw new Exception($result['error'] ?? 'Unknown error');
    }
    
} catch (Exception $e) {
    error_log("Error in deleteAllSubmissions.php: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
